﻿<%@ Page Language="c#" autoeventwireup="false" CodePage="1200" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="eb" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.Core" %>
<%@ import Namespace="Soneta.Handel" %>
<%@ import Namespace="Soneta.Towary" %>
<%@ import Namespace="Soneta.Magazyny" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
	<head>
	<title>Spis z natury - szczegóły</title>
	<script runat="server">

        public class ParametryBase : ContextBase {
            public ParametryBase(Context cx)
                : base(cx) {
            }

            private Magazyn _magazyn;

            [Context]
            public Magazyn Magazyn {
                get { return _magazyn; }
                set { _magazyn = value; OnChanged(EventArgs.Empty); }
            }

        }

        ParametryBase parametry;

        [Context]
        public ParametryBase Parametry {
            get { return parametry; }
            set { parametry = value; }
        }
        
        int lp = 0;
   
        void dc_ContextLoad(Object sender, EventArgs args) {            
            
            var pars = (ObrotyParams)
                dc[typeof(ObrotyParams)];
            
            if (pars.DataStanu != pars.Okres.Okres.To && pars.DataStanu != Date.Empty)
			    throw new InvalidOperationException("Szczegółowy raport spisu z natury może być robiony tylko według stanu aktualnego oraz na koniec okresu magazynowego.");
                            
            ReportHeader.Title += String.Format("Okres magazynowy: <STRONG>{0}</STRONG>|", pars.Okres);
            ReportHeader.Title += String.Format("Magazyn: <STRONG>{0}</STRONG>|", Parametry.Magazyn != null ? Parametry.Magazyn.ToString().Replace("&", "&amp;") : "(wszystkie)" );
            ReportHeader.Title += String.Format("Dostawca: <STRONG>{0}</STRONG>|", pars.Dostawca);
            lp = 0;
            
        }
 
        void Grid_ItemsGet(Object sender, ItemsGetEventArgs args) {

            if (args.Deep==1) {
                
                var pars = (ObrotyParams)
                    dc[typeof(ObrotyParams)];
    
                Towar t = (Towar)args.Row;
                OkresMagazynowy o = pars.Okres;
                Magazyn m = parametry.Magazyn;
    
                args.Enumerable = t.Module.Magazyny.Zasoby.WgTowar[t, o, m];
            }
            
        }
	       
        void Grid_BeforeRow(Object sender, RowEventArgs args) {
            Zasob z = (Zasob)args.Row;
            args.VisibleRow = z.Partia.Typ==TypPartii.Magazynowy;
            if (args.VisibleRow)
                colLp.EditValue = ++lp;
        }

        protected void Grid_AfterRender(object sender, EventArgs e) {
            Currency tv = colWartosc.TotalValue != null ? new Currency(Math.Round((decimal)colWartosc.TotalValue, 2)) : Currency.Zero;
            WartośćSłownie.EditValue = tv;
            dataLabelPosumowanie.EditValue = string.Format("Spis zakończono na pozycji {0}.", lp);
        }
    </script>
	<meta content="C#" name="CODE_LANGUAGE" />
	<meta content="JavaScript" name="vs_defaultClientScript" />
	<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema" />
	</head>
	<body>
		<form method="post" runat="server">
			<ea:DataContext id="dc" runat="server" oncontextload="dc_ContextLoad"></ea:DataContext>
			<eb:ReportHeader runat="server" id="ReportHeader" title="Spis z natury - szczegóły|</STRONG>"></eb:ReportHeader>
			<ea:Grid id="Grid" runat="server" 
                RowTypeName="Soneta.Magazyny.Zasob,Soneta.Handel" OnItemsGet="Grid_ItemsGet" 
                OnBeforeRow="Grid_BeforeRow" OnAfterRender="Grid_AfterRender">
				<Columns>
					<ea:GridColumn ID="colLp" Width="6" Align="Right" Caption="Lp." EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn DataMember="Towar" Total="Info" Caption="Towar" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="18" Align="Right" DataMember="Partia.Dokument" Caption="Dokument" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Partia.Dokument.Data" Caption="Data" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="IlośćZasobu" Total="Sum" Caption="Ilość" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn Width="12" Align="Right" DataMember="Partia.Cena" Caption="Cena" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
					<ea:GridColumn ID="colWartosc" Width="14" Align="Right" DataMember="Partia.Wartosc" Total="Sum" Caption="Wartość" Format="{0:n}" EncodeHTML="True" runat="server"></ea:GridColumn>
				</Columns>
			</ea:Grid>
			<br />
			<table>
			    <tr>
			        <td>
			        <font size="2"><em>Wartość słownie: </em></font>
			        </td>
			        <td>
			            <font size="2"><ea:DataLabel runat="server" id="WartośćSłownie" Format="{0:+t}" Bold="false"></ea:DataLabel></font>
			        </td>
			    </tr>
			    <tr>
			        <td>
			        
			        </td>
			    </tr>
			</table>
			<br />
			<ea:DataLabel ID="dataLabelPosumowanie" runat=server> </ea:DataLabel>
			<br /><br />
			<em>
			Skład komisji inwentaryzacyjnej:<br />
			1. .................................................. podpis..............................<br />
			2. .................................................. podpis..............................<br />
			3. .................................................. podpis..............................<br />
			4. .................................................. podpis..............................<br />
			</em>
			<br />
			<em>
			Uwagi:<br />
			....................................................................................................<br />
			....................................................................................................<br />
			....................................................................................................<br />
			....................................................................................................<br />
			</em>
			<br />
			<eb:ReportFooter id="ReportFooter" runat="server">
			</eb:ReportFooter>			
		</form>
	</body>
</html>
